<?php
require_once 'phpqrcode/qrlib.php';

function generateQRCode($data, $filepath) {
    QRcode::png($data, $filepath, QR_ECLEVEL_L, 3);
}

if (!empty($_FILES['files']['name'][0])) {
    foreach ($_FILES['files']['tmp_name'] as $index => $tmpPath) {
        $originalName = $_FILES['files']['name'][$index];
        $content = file_get_contents($tmpPath);
        
        preg_match_all('/"ps"\s*:\s*"([^"]+)"/', $content, $matches);
        if (!empty($matches[1])) {
            foreach ($matches[1] as $ps) {
                $user = preg_replace('/-\d+$/', '', $ps);
                $userDir = __DIR__ . "/users/$user";
                $subDir = "$userDir/sub";
                if (!is_dir($subDir)) mkdir($subDir, 0777, true);

                file_put_contents("$subDir/sub", $content, FILE_APPEND);
                
                $encoded = base64_encode($content);
                generateQRCode($encoded, "$userDir/qr.png");

                $html = "<pre>" . htmlspecialchars($content) . "</pre>";
                file_put_contents("$userDir/index.html", $html);
            }
        }
    }
    echo "✅ فایل‌ها با موفقیت پردازش شدند.";
} else {
    echo "❌ هیچ فایلی انتخاب نشده است.";
}
