<?php
// list-users.php - مدیریت کاربران و کانفیگ‌ها
$uploadDir = __DIR__ . '/upload';
$userDir = __DIR__ . '/users';

function getUsersFromConfigs($dir) {
    $users = [];
    $files = glob("$dir/*.txt");
    foreach ($files as $file) {
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (preg_match('/#.*?-(.*?)-\\d+$/', $line, $matches)) {
                $username = trim($matches[1]);
                if (!in_array($username, $users)) {
                    $users[] = $username;
                }
            }
        }
    }
    sort($users);
    return $users;
}

$users = getUsersFromConfigs($uploadDir);

// شمارش کانکشن‌ها برای هر یوزر
$configsCount = [];
foreach (glob("$uploadDir/*.txt") as $file) {
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (preg_match('/#.*?-(.*?)-\\d+$/', $line, $matches)) {
            $username = trim($matches[1]);
            $configsCount[$username] = ($configsCount[$username] ?? 0) + 1;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📦 مدیریت کاربران و کانفیگ‌ها</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: Tahoma, sans-serif; direction: rtl; background: #f3f4f6; padding: 10px; }
        header { background: #1e40af; color: white; padding: 1rem; text-align: center; margin-bottom: 1rem; border-radius: 0.5rem; }
        main { max-width: 1200px; margin: 0 auto; }
        .section { background: white; border-radius: 0.5rem; box-shadow: 0 2px 4px rgba(0,0,0,0.1); padding: 1rem; margin-bottom: 1rem; }
        .upload-btn { background: #10b981; color: white; padding: 0.5rem 1rem; border-radius: 0.375rem; }
        .upload-btn:hover { background: #059669; }
        .user-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1rem; }
        .user-card { background: #fff; border-radius: 0.375rem; padding: 0.75rem; position: relative; }
        .user-actions { display: flex; gap: 0.5rem; margin-top: 0.5rem; }
        .btn { background: #10b981; color: white; padding: 0.25rem 0.75rem; border-radius: 0.25rem; font-size: 0.875rem; }
        .btn:hover { background: #059669; }
        .btn:disabled { background: #a3a3a3; cursor: not-allowed; }
        .link { color: #3b82f6; text-decoration: none; font-size: 0.875rem; }
        .link:hover { text-decoration: underline; }
        .status-icon { font-size: 1rem; margin-left: 0.25rem; }
        .status { color: #10b981; font-size: 0.875rem; margin-top: 0.25rem; }
        details { margin-top: 0.5rem; }
        details summary { cursor: pointer; padding: 0.25rem; background: #f3f4f6; border-radius: 0.25rem; }
        details[open] summary { background: #e5e7eb; }
        details div { padding: 0.5rem; background: #fff; border-radius: 0.25rem; }
        details img { max-width: 100px; }
        .config-status { color: #6b7280; font-size: 0.875rem; }
    </style>
</head>
<body>
    <header>
        <h1 class="text-2xl font-bold">📦 مدیریت کاربران و کانفیگ‌ها</h1>
    </header>
    <main>
        <section class="section">
            <h2 class="text-lg font-semibold mb-2">👥 لیست کاربران</h2>
            <div class="user-grid">
                <?php foreach ($users as $user): 
                    $userPath = "$userDir/$user";
                    $indexExists = file_exists("$userPath/index.html");
                    $subExists = file_exists("$userPath/sub.txt");
                    $qrExists = file_exists("$userPath/qrcode.png");
                    $isReady = $indexExists && $subExists && $qrExists;
                ?>
                    <div class="user-card">
                        <div>
                            👤 <strong><?= htmlspecialchars($user) ?></strong>
                            <?php if ($isReady): ?>
                                <span class="status-icon">✅</span>
                            <?php endif; ?>
                            <span class="config-status">تعداد کانکشن: <?= $configsCount[$user] ?? 0 ?></span>
                            <div id="status-<?= htmlspecialchars($user) ?>" class="status hidden"></div>
                        </div>
                        <div class="user-actions">
                            <a class="link" href="https://sells.vsparts.cc/users/<?= $user ?>/" target="_blank">صفحه</a>
                            <a class="link" href="https://sells.vsparts.cc/users/<?= $user ?>/sub.txt" target="_blank">سابسکرایب</a>
                            <form style="display:inline" onsubmit="generateSubscription(event, '<?= htmlspecialchars($user) ?>')">
                                <input type="hidden" name="username" value="<?= htmlspecialchars($user) ?>">
                                <button type="submit" class="btn">ساخت</button>
                            </form>
                        </div>
                        <details>
                            <summary>جزئیات</summary>
                            <div>
                                <p><strong>لینک سابسکرایب:</strong> <a href="https://sells.vsparts.cc/users/<?= $user ?>/sub.txt" target="_blank">https://sells.vsparts.cc/users/<?= $user ?>/sub.txt</a></p>
                                <p><strong>صفحه کاربر:</strong> <a href="https://sells.vsparts.cc/users/<?= $user ?>/" target="_blank">https://sells.vsparts.cc/users/<?= $user ?>/</a></p>
                                <?php if ($qrExists): ?>
                                    <p><strong>QR Code:</strong> <img src="/users/<?= $user ?>/qrcode.png" alt="QR Code"></p>
                                <?php endif; ?>
                            </div>
                        </details>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
        <section class="section">
            <h2 class="text-lg font-semibold mb-2">📤 آپلود کانفیگ‌ها</h2>
            <form id="uploadForm" action="upload.php" method="post" enctype="multipart/form-data" class="mb-2">
                <input type="file" name="configs[]" multiple accept=".txt" class="block w-full mb-2 p-1 border rounded">
                <button type="submit" class="upload-btn">آپلود</button>
            </form>
            <div id="uploadStatus" class="config-status"></div>
        </section>
    </main>
    <script>
        // آپلود فایل
        document.getElementById('uploadForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            const statusDiv = document.getElementById('uploadStatus');
            statusDiv.textContent = 'در حال آپلود...';

            fetch('upload.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                statusDiv.textContent = data.status === 'success' ? `✅ ${data.uploaded} فایل آپلود شد` : `❌ ${data.message}`;
            })
            .catch(error => {
                statusDiv.textContent = '❌ خطا در آپلود: ' + error.message;
            });
        });

        // ساخت سابسکریپشن
        function generateSubscription(event, username) {
            event.preventDefault();
            const statusDiv = document.getElementById(`status-${username}`);
            statusDiv.classList.remove('hidden');
            statusDiv.textContent = 'در حال ساخت...';

            fetch(`generate.php?username=${encodeURIComponent(username)}`, {
                method: 'GET'
            })
            .then(response => response.text())
            .then(data => {
                statusDiv.textContent = data;
                if (data.startsWith('✅')) {
                    const details = statusDiv.closest('.user-card').querySelector('details');
                    if (details) {
                        const img = details.querySelector('img');
                        if (img) img.src = `/users/${username}/qrcode.png?${new Date().getTime()}`;
                    }
                }
            })
            .catch(error => {
                statusDiv.textContent = '❌ خطا: ' + error.message;
                console.error('Error details:', error); // دیباگ خطا
            });
        }
    </script>
</body>
</html>