<?php
if (isset($_GET['username'])) {
    $username = preg_replace('/[^a-zA-Z0-9._-]/', '', $_GET['username']);
    $uploadDir = __DIR__ . '/upload/';
    $userDir = __DIR__ . "/users/$username/";

    if (!file_exists($userDir)) {
        mkdir($userDir, 0755, true);
    }

    $subscription = '';
    $configs = [];

    foreach (glob($uploadDir . "*.txt") as $filename) {
        $content = file_get_contents($filename);
        preg_match_all('/^vless:\/\/[^\s#]+#([^\s]+)/m', $content, $matches, PREG_OFFSET_CAPTURE);

        foreach ($matches[1] as $index => $match) {
            $tag = $match[0];
            if (preg_match("/-" . preg_quote($username, '/') . "-/", $tag)) {
                $fullLine = trim(explode("\n", substr($content, $matches[0][$index][1]))[0]);
                $configs[] = $fullLine;
                $subscription .= $fullLine . "\n";
            }
        }
    }

    if (!empty($subscription)) {
        file_put_contents($userDir . 'sub.txt', $subscription);

        // QR code (just for sub.txt link)
        $subscriptionLink = "https://sells.vsparts.cc/users/$username/sub.txt"; // دامنه درست
        $qrCodePath = $userDir . 'qrcode.png';

        include_once 'phpqrcode/qrlib.php';
        QRcode::png($subscriptionLink, $qrCodePath, QR_ECLEVEL_L, 4);

        // index.html
        $html = "<!DOCTYPE html><html lang='fa'><head><meta charset='UTF-8'><title>$username Subscription</title><style>body{font-family:Tahoma;direction:rtl;padding:20px;}</style></head><body>";
        $html .= "<h2>🔗 لینک سابسکریپشن:</h2><p><a href='$subscriptionLink' target='_blank'>$subscriptionLink</a></p>";
        $html .= "<h3>📱 QR Code:</h3><img src='qrcode.png' alt='QR Code'>";
        $html .= "<h3>📦 کانفیگ‌ها:</h3><pre>";
        foreach ($configs as $line) {
            $html .= htmlspecialchars($line) . "\n";
        }
        $html .= "</pre></body></html>";
        file_put_contents($userDir . 'index.html', $html);

        echo "✅ سابسکریپشن برای $username ساخته شد.";
    } else {
        echo "⚠️ کانفیگی برای این یوزر پیدا نشد.";
    }
} else {
    echo "❌ نام یوزر مشخص نیست.";
}