<?php
// دریافت نام یوزر از طریق POST
if (!isset($_POST['username'])) {
    http_response_code(400);
    echo "نام کاربر ارسال نشده.";
    exit;
}

$username = trim($_POST['username']);
$basePath = __DIR__ . '/users/' . $username;
$domain = 'https://sells.vsparts.cc';

// اگر پوشه وجود نداشت بساز
if (!is_dir($basePath)) {
    mkdir($basePath, 0755, true);
}

// آدرس فایل config اصلی
$allConfigPath = __DIR__ . '/WS.txt';
if (!file_exists($allConfigPath)) {
    http_response_code(500);
    echo "فایل کانفیگ اصلی پیدا نشد.";
    exit;
}

// استخراج خطوط مربوط به این یوزر
$allConfigs = file($allConfigPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$userConfigs = [];
foreach ($allConfigs as $line) {
    if (stripos($line, $username) !== false && stripos($line, 'vless://') === 0) {
        $userConfigs[] = $line;
    }
}

if (empty($userConfigs)) {
    http_response_code(404);
    echo "هیچ کانفیگی برای این کاربر یافت نشد.";
    exit;
}

// ساخت فایل sub.txt
$subFilePath = "$basePath/sub.txt";
file_put_contents($subFilePath, implode("\n", $userConfigs));

// ساخت لینک کامل
$subUrl = "$domain/users/$username/sub";

// ساخت QR code
$qrPath = "$basePath/qr.png";
$qrApi = "https://api.qrserver.com/v1/create-qr-code/?data=" . urlencode($subUrl) . "&size=200x200";
file_put_contents($qrPath, file_get_contents($qrApi));

// ساخت فایل index.html
$indexHtml = "<!DOCTYPE html>
<html lang='fa'>
<head>
  <meta charset='UTF-8'>
  <title>اشتراک $username</title>
  <style>
    body { font-family: Tahoma, sans-serif; direction: rtl; padding: 20px; }
    .config { background: #f5f5f5; padding: 10px; margin: 10px 0; font-family: monospace; }
  </style>
</head>
<body>
  <h2>اشتراک کاربر: $username</h2>
  <p><strong>لینک سابسکریپشن:</strong> <a href='$subUrl'>$subUrl</a></p>
  <img src='qr.png' alt='QR Code'>
  <h3>لیست کانفیگ‌ها:</h3>";

foreach ($userConfigs as $conf) {
    $indexHtml .= "<div class='config'>" . htmlspecialchars($conf) . "</div>";
}

$indexHtml .= "</body></html>";
file_put_contents("$basePath/index.html", $indexHtml);

// پایان
echo "پوشه کاربر '$username' ساخته شد.";
