<?php
$dir = __DIR__ . '/upload';
$configFiles = glob("$dir/*.txt");

$users = [];

foreach ($configFiles as $file) {
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        // بررسی الگوی یوزرنیم در انتهای هر کانفیگ
        if (preg_match('/#.*?-([a-zA-Z0-9._]+)(?:-[0-9]+)?$/', $line, $matches)) {
            $username = $matches[1];
            if (!isset($users[$username])) {
                $users[$username] = [
                    'configs' => [],
                    'ready' => false,
                    'username' => $username,
                    'subLink' => "https://sells.vsparts.cc/users/$username/sub",
                    'pageLink' => "https://sells.vsparts.cc/users/$username/"
                ];
            }
            $users[$username]['configs'][] = $line;
        }
    }
}

// بررسی وجود فایل‌های مورد نیاز برای هر یوزر
foreach ($users as $username => &$user) {
    $folder = __DIR__ . "/users/$username";
    $sub = "$folder/sub";
    $index = "$folder/index.html";
    $qr = "$folder/qrcode.png";

    if (file_exists($folder) && file_exists($sub) && file_exists($index) && file_exists($qr)) {
        $user['ready'] = true;
    }
}

header('Content-Type: application/json');
echo json_encode(array_values($users), JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
