<?php
// list-users.php - نمایش لیست یوزرها با دکمه ساخت سابسکریپشن و وضعیت ساخت فایل‌ها

$uploadDir = __DIR__ . '/upload';
$userDir = __DIR__ . '/users';

function getUsersFromConfigs($dir) {
    $users = [];
    $files = glob("$dir/*.txt");
    foreach ($files as $file) {
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (preg_match('/#.*?-(.*?)-\\d+$/', $line, $matches)) {
                $username = trim($matches[1]);
                if (!in_array($username, $users)) {
                    $users[] = $username;
                }
            }
        }
    }
    sort($users);
    return $users;
}

$users = getUsersFromConfigs($uploadDir);

?>
<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <title>مدیریت کاربران</title>
  <style>
    body { font-family: Tahoma, sans-serif; direction: rtl; background: #f9f9f9; padding: 20px; }
    h2 { color: #333; }
    .user-box { background: #fff; border: 1px solid #ddd; padding: 15px; margin-bottom: 10px; border-radius: 8px; display: flex; justify-content: space-between; align-items: center; }
    .user-actions { display: flex; gap: 10px; }
    .btn { padding: 5px 10px; background: #007bff; color: #fff; border: none; border-radius: 4px; cursor: pointer; }
    .btn:disabled { background: #aaa; cursor: not-allowed; }
    .link { text-decoration: none; color: #007bff; margin-right: 10px; }
    .status-icon { font-size: 18px; margin-right: 5px; }
  </style>
</head>
<body>
  <h2>📦 لیست کاربران</h2>
  <?php foreach ($users as $user): 
    $userPath = "$userDir/$user";
    $indexExists = file_exists("$userPath/index.html");
    $subExists = file_exists("$userPath/sub.txt");
    $qrExists = file_exists("$userPath/qrcode.png");
    $isReady = $indexExists && $subExists && $qrExists;
  ?>
    <div class="user-box">
      <div>
        👤 <strong><?= htmlspecialchars($user) ?></strong>
        <?php if ($isReady): ?>
          <span class="status-icon">✅</span>
        <?php endif; ?>
      </div>
      <div class="user-actions">
        <a class="link" href="/users/<?= $user ?>/" target="_blank">صفحه کاربر</a>
        <a class="link" href="/users/<?= $user ?>/sub.txt" target="_blank">لینک سابسکریپشن</a>
        <form action="generate.php" method="post" style="display:inline">
          <input type="hidden" name="username" value="<?= htmlspecialchars($user) ?>">
          <button class="btn" type="submit">ساخت سابسکریپشن</button>
        </form>
      </div>
    </div>
  <?php endforeach; ?>
</body>
</html>
